define([
    'underscore',
    'backbone',
    'marionette',
    'modules/notifications/notifications-module',
    'modules/notifications/notifications-list',
    'text!modules/notifications/notifications-layout.html',
    'text!modules/page/content/_primary-header.html',
    'App',
    'User',
],
function(
    _,
    Backbone,
    Marionette,
    module,
    NotificationsList,
    template,
    _primaryHeaderTemplate,
    app,
    User
) {
    'use strict';
    
    return Backbone.Marionette.View.extend({
        template: _.template(template),
        regions: {notificationsListRegion: '.notifications-layout-section'},
        events: {'click #back-btn': 'routeToAppointments'},
        onRender: function() {
            this.showNotificationsList();
        },
        fetchNotificationsCollection: function() {
            return module.notifications.fetch({
                url: app.resources.get('notifications').formatHref({
                    'assigning-authority': User.get('idType'),
                    'unique-id': User.get('id'),
                }),
            });
        },
        showNotificationsList: function() {
            this.fetchNotificationsCollection().done(function() {
                var notificationsCollection;
                var notificationsListRegion;
                var view;
                
                if (!this.isDestroyed()) {
                    notificationsCollection = module.notifications;

                    if (notificationsCollection.size() > 0) {
                        view = new NotificationsList({collection: module.notifications});
                    } else {
                        view = new (Backbone.Marionette.View.extend({
                            template: _.template('<p>You do not have any notifications at this time.</p>'),
                        }))();
                    }
                    notificationsListRegion = this.getRegion('notificationsListRegion');
                    notificationsListRegion.show(view);
                }
            }.bind(this));
        },
        routeToAppointments: function() {
            Backbone.history.navigate('appointments', {trigger: true});
        },
        templateContext: {primaryHeader: _.template(_primaryHeaderTemplate)},
    });
});
